import sequelize from './config/database.ts';
import WhatWeDo from './models/WhatWeDo.ts';

const whatWeDoData = [
  {
    icon: 'Users',
    title: '15+ Years Experience',
    description: 'Over a decade of expertise in IT solutions, serving 500+ satisfied clients across Maharashtra and India with proven track record.',
    features: ['500+ Happy Clients', '15+ Years Expertise', 'Proven Track Record', 'Trusted Partner'],
    color: 'from-[#004AAD] to-[#004AAD]/80',
    bgColor: 'bg-gradient-to-br from-[#004AAD]/5 to-[#004AAD]/10',
    iconColor: 'text-[#004AAD]',
    position: 'left',
    order: 1,
    isActive: true,
  },
  {
    icon: 'Zap',
    title: 'Fast & Reliable Delivery',
    description: 'We deliver projects on time, every time. Our streamlined development process ensures quick turnaround without compromising quality.',
    features: ['On-Time Delivery', 'Quality Assurance', 'Fast Development', '24/7 Support'],
    color: 'from-[#FF7A00] to-[#FF7A00]/80',
    bgColor: 'bg-gradient-to-br from-[#FF7A00]/5 to-[#FF7A00]/10',
    iconColor: 'text-[#FF7A00]',
    position: 'right',
    order: 2,
    isActive: true,
  },
  {
    icon: 'Shield',
    title: 'Local Expertise, Global Standards',
    description: 'Based in Chhatrapati Sambhajinagar, we understand local business needs while maintaining international quality standards and best practices.',
    features: ['Local Understanding', 'Global Standards', 'Cultural Awareness', 'Regional Support'],
    color: 'from-[#004AAD] to-[#004AAD]/80',
    bgColor: 'bg-gradient-to-br from-[#004AAD]/5 to-[#004AAD]/10',
    iconColor: 'text-[#004AAD]',
    position: 'left',
    order: 3,
    isActive: true,
  },
  {
    icon: 'BarChart3',
    title: 'Innovative Solutions',
    description: 'Cutting-edge technology and innovative approaches to solve complex business challenges and drive digital transformation.',
    features: ['Latest Technology', 'Innovation Focus', 'Digital Transformation', 'Future-Ready'],
    color: 'from-[#FF7A00] to-[#FF7A00]/80',
    bgColor: 'bg-gradient-to-br from-[#FF7A00]/5 to-[#FF7A00]/10',
    iconColor: 'text-[#FF7A00]',
    position: 'right',
    order: 4,
    isActive: true,
  },
];

async function seedWhatWeDo() {
  try {
    console.log('Starting What We Do seeding...');
    
    // Sync the model
    await WhatWeDo.sync({ force: false });
    
    // Clear existing data
    await WhatWeDo.destroy({ where: {} });
    
    // Insert new data
    for (const item of whatWeDoData) {
      await WhatWeDo.create(item);
      console.log(`Created: ${item.title}`);
    }
    
    console.log('What We Do seeding completed successfully!');
    process.exit(0);
  } catch (error) {
    console.error('Error seeding What We Do:', error);
    process.exit(1);
  }
}

seedWhatWeDo();
