import express from 'express';
import {
  getWhatWeDoItems,
  getAllWhatWeDoItems,
  createWhatWeDoItem,
  updateWhatWeDoItem,
  deleteWhatWeDoItem,
  reorderWhatWeDoItems,
} from '../controllers/whatWeDo.controller.js';
import { authenticateJWT } from '../middleware/auth.js';
// import {  } from '../middleware/auth.js';

const router = express.Router();

// Public routes
router.get('/', getWhatWeDoItems);

// Admin routes (protected)
router.get('/admin', authenticateJWT, getAllWhatWeDoItems);
router.post('/admin', authenticateJWT, createWhatWeDoItem);
router.put('/admin/:id', authenticateJWT, updateWhatWeDoItem);
router.delete('/admin/:id', authenticateJWT, deleteWhatWeDoItem);
router.put('/admin/reorder', authenticateJWT, reorderWhatWeDoItems);

export default router;
