import express from 'express';
import {
  getAllCareers,
  getCareerById,
  createCareer,
  updateCareer,
  deleteCareer,
  toggleCareerStatus,
  getCareerStats
} from '../controllers/career.controller.js';
import { authenticateJWT } from '../middleware/auth.js';
// import { authenticateJWT } from '../middleware/auth.js';

const router = express.Router();

// Public routes (no authentication required)
router.get('/', getAllCareers); // Get all active job openings
router.get('/stats', getCareerStats); // Get career statistics
router.get('/:id', getCareerById); // Get single job opening

// Protected routes (authentication required)
router.post('/', authenticateJWT, createCareer); // Create new job opening
router.put('/:id', authenticateJWT, updateCareer); // Update job opening
router.delete('/:id', authenticateJWT, deleteCareer); // Delete job opening
router.patch('/:id/toggle', authenticateJWT, toggleCareerStatus); // Toggle job opening status

export default router;
