import express from 'express';
import * as bannerController from '../controllers/banner.controller.js';
import { authenticateJWT } from '../middleware/auth.js';

const bannerRoutes = express.Router();

bannerRoutes.get('/', bannerController.getBanner)
           .post('/', authenticateJWT, bannerController.createBanner)
           .put('/:id', authenticateJWT, bannerController.updateBanner)
           .delete('/:id', authenticateJWT, bannerController.deleteBanner);

export default bannerRoutes;
