import { DataTypes, Model,type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface ITestimonialAttributes {
  id: number;
  name: string;
  role: string;
  text: string;
  image: string;
  stars: number;
  size: 'small' | 'large';
  createdAt: Date;
  updatedAt: Date;
}

export interface ITestimonialCreationAttributes extends Optional<ITestimonialAttributes, 'id' | 'size' | 'createdAt' | 'updatedAt'> {}

export interface ITestimonialInstance extends Model<ITestimonialAttributes, ITestimonialCreationAttributes>, ITestimonialAttributes {}

const Testimonial = sequelize.define<ITestimonialInstance, ITestimonialCreationAttributes>('Testimonial', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  name: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  role: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  text: {
    type: DataTypes.STRING(1000),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 1000]
    }
  },
  image: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  },
  stars: {
    type: DataTypes.INTEGER,
    allowNull: false,
    validate: {
      min: 1,
      max: 5
    }
  },
  size: {
    type: DataTypes.ENUM('small', 'large'),
    defaultValue: 'small'
  }
}, {
  tableName: 'testimonials',
  timestamps: true
});

export default Testimonial;