import { DataTypes, Model,type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface ITeamMemberAttributes {
  id: number;
  name: string;
  role: string;
  image: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface ITeamMemberCreationAttributes extends Optional<ITeamMemberAttributes, 'id' | 'createdAt' | 'updatedAt'> {}

export interface ITeamMemberInstance extends Model<ITeamMemberAttributes, ITeamMemberCreationAttributes>, ITeamMemberAttributes {}

const TeamMember = sequelize.define<ITeamMemberInstance, ITeamMemberCreationAttributes>('TeamMember', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  name: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  role: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  image: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  }
}, {
  tableName: 'team_members',
  timestamps: true
});

export default TeamMember;