import { DataTypes, Model, type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface IConfigAttributes {
  id: number;
  key: string;
  value: string;
  secret: boolean;
  required: boolean;
  label: string | null;
  createdAt: Date;
  updatedAt: Date;
}

export interface IConfigCreationAttributes extends Optional<IConfigAttributes, 'id' | 'label' | 'createdAt' | 'updatedAt'> {}

export interface IConfigInstance extends Model<IConfigAttributes, IConfigCreationAttributes>, IConfigAttributes {}

const Config = sequelize.define<IConfigInstance, IConfigCreationAttributes>('Config', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  key: {
    type: DataTypes.STRING(100),
    allowNull: false,
    unique: true,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  value: {
    type: DataTypes.TEXT,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  },
  secret: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
  required: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
  label: {
    type: DataTypes.STRING(200),
    allowNull: true
  }
}, {
  tableName: 'configs',
  timestamps: true
});

export default Config;
