import { DataTypes, Model,type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface IBannerAttributes {
  id: number;
  message: string;
  link: string | null;
  color: string;
  isActive: boolean;
  createdAt: Date;
  updatedAt: Date;
}

export interface IBannerCreationAttributes extends Optional<IBannerAttributes, 'id' | 'link' | 'color' | 'isActive' | 'createdAt' | 'updatedAt'> {}

export interface IBannerInstance extends Model<IBannerAttributes, IBannerCreationAttributes>, IBannerAttributes {}

const Banner = sequelize.define<IBannerInstance, IBannerCreationAttributes>('Banner', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  message: {
    type: DataTypes.STRING(200),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 200]
    }
  },
  link: {
    type: DataTypes.STRING(500),
    allowNull: true,
    validate: {
      len: [0, 500]
    }
  },
  color: {
    type: DataTypes.STRING(7),
    allowNull: false,
    defaultValue: '#3B82F6',
    validate: {
      is: /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/
    }
  },
  isActive: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  }
}, {
  tableName: 'banners',
  timestamps: true
});

export default Banner;
