import type { RequestHandler } from 'express';
import jwt from 'jsonwebtoken';
import User from '../models/User.js';

interface JWTPayload {
  userId: string;
  iat?: number;
  exp?: number;
}

export const authenticateJWT: RequestHandler = async (req, res, next) => {
  try {
    const token = req.header('Authorization')?.replace('Bearer ', '');
    console.log('Auth token:', token ? 'Present' : 'Missing');
    
    if (!token) {
      console.log('No token provided');
      res.status(401).json({ message: 'Access denied. No token provided.' });
      return;
    }

    const decoded = jwt.verify(token, process.env.JWT_SECRET || 'your-secret-key') as JWTPayload;
    console.log('Decoded token:', decoded);

    const userDoc = await User.findByPk(decoded.userId, {
      attributes: { exclude: ['password'] }
    });
    if (!userDoc) {
      console.log('User not found for ID:', decoded.userId);
      res.status(401).json({ message: 'Invalid token.' });
      return;
    }

    console.log('User authenticated:', userDoc.email);

    // Convert to plain object so it matches Express.User (IUser)
    req.user = userDoc.toJSON() as Express.User;

    next();
  } catch (error) {
    console.error('Auth error:', error);
    res.status(401).json({ message: 'Invalid token.' });
  }
};




