import express from 'express';
import {
  getAllJobApplications,
  getJobApplicationById,
  storeJobApplicationData,
  createJobApplication,
  updateJobApplicationStatus,
  deleteJobApplication,
  getJobApplicationStats
} from '../controllers/jobApplication.controller.js';
import { authenticateJWT } from '../middleware/auth.js';
import { documentUpload } from '../middleware/documentUpload.js';

const router = express.Router();

// Public routes (no authentication required)
router.post('/store', documentUpload.fields([
  { name: 'resume', maxCount: 1 },
  { name: 'coverLetter', maxCount: 1 }
]), storeJobApplicationData); // Store job application data temporarily
router.post('/create', createJobApplication); // Create job application (after OTP verification)

// Protected routes (authentication required)
router.get('/', authenticateJWT, getAllJobApplications); // Get all job applications
router.get('/stats', authenticateJWT, getJobApplicationStats); // Get job application statistics
router.get('/:id', authenticateJWT, getJobApplicationById); // Get single job application
router.put('/:id/status', authenticateJWT, updateJobApplicationStatus); // Update application status
router.delete('/:id', authenticateJWT, deleteJobApplication); // Delete job application

export default router;
