import express from 'express';
import * as contactController from '../controllers/contact.controller.js';
import { authenticateJWT } from '../middleware/auth.js';

const contactRoutes = express.Router();

contactRoutes.post('/', contactController.createContact)
            .get('/', authenticateJWT, contactController.getAllContacts)
            .get('/:id', authenticateJWT, contactController.getContactById)
            .put('/:id', authenticateJWT, contactController.updateContact)
            .delete('/:id', authenticateJWT, contactController.deleteContact);

export default contactRoutes;
