import express from 'express';
import * as configController from '../controllers/config.controller.js';
import { authenticateJWT } from '../middleware/auth.js';

const configRoutes = express.Router();

configRoutes.get('/', configController.getConfig)
           .get('/stats', configController.getConfigStats)
           .post('/', authenticateJWT, configController.upsertConfig);

export default configRoutes;
