import express from 'express';
import * as companyController from '../controllers/company.controller.js';
import { authenticateJWT } from '../middleware/auth.js';
import { upload } from '../middleware/upload.js';

const companyRoutes = express.Router();

companyRoutes.get('/', companyController.getCompany)
             .post('/', authenticateJWT, upload.fields([
               { name: 'logoFile', maxCount: 1 },
               { name: 'darkLogoFile', maxCount: 1 },
               { name: 'founderAvatarFile', maxCount: 1 }
             ]), companyController.createCompany)
             .put('/', authenticateJWT, upload.fields([
               { name: 'logoFile', maxCount: 1 },
               { name: 'darkLogoFile', maxCount: 1 },
               { name: 'founderAvatarFile', maxCount: 1 }
             ]), companyController.updateCompany);

export default companyRoutes;
