import express from 'express';
import * as appointmentController from '../controllers/appointment.controller.js';
import { authenticateJWT } from '../middleware/auth.js';

const appointmentRoutes = express.Router();

appointmentRoutes.post('/', appointmentController.createAppointment)
                .get('/', authenticateJWT, appointmentController.getAllAppointments)
                .get('/:id', authenticateJWT, appointmentController.getAppointmentById)
                .put('/:id', authenticateJWT, appointmentController.updateAppointment)
                .delete('/:id', authenticateJWT, appointmentController.deleteAppointment);

export default appointmentRoutes;
