import { DataTypes, Model, type Optional } from 'sequelize';
import sequelize from '../config/database.js';

interface WhatWeDoAttributes {
  id: number;
  icon: string;
  title: string;
  description: string;
  features: string[];
  color: string;
  bgColor: string;
  iconColor: string;
  position: 'left' | 'right' | 'center';
  order: number;
  isActive: boolean;
  createdAt?: Date;
  updatedAt?: Date;
}

interface WhatWeDoCreationAttributes extends Optional<WhatWeDoAttributes, 'id' | 'createdAt' | 'updatedAt'> {}

class WhatWeDo extends Model<WhatWeDoAttributes, WhatWeDoCreationAttributes> implements WhatWeDoAttributes {
  public id!: number;
  public icon!: string;
  public title!: string;
  public description!: string;
  public features!: string[];
  public color!: string;
  public bgColor!: string;
  public iconColor!: string;
  public position!: 'left' | 'right' | 'center';
  public order!: number;
  public isActive!: boolean;
  public readonly createdAt!: Date;
  public readonly updatedAt!: Date;
}

WhatWeDo.init(
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    icon: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    features: {
      type: DataTypes.JSON,
      allowNull: false,
      defaultValue: [],
    },
    color: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    bgColor: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    iconColor: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    position: {
      type: DataTypes.ENUM('left', 'right', 'center'),
      allowNull: false,
      defaultValue: 'left',
    },
    order: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    isActive: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    sequelize,
    modelName: 'WhatWeDo',
    tableName: 'what_we_do',
    timestamps: true,
  }
);

export default WhatWeDo;
