import { DataTypes, Model,type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface IFeatureAttributes {
  id: number;
  title: string;
  desc: string;
  iconKey: string;
  color: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface IFeatureCreationAttributes extends Optional<IFeatureAttributes, 'id' | 'color' | 'createdAt' | 'updatedAt'> {}

export interface IFeatureInstance extends Model<IFeatureAttributes, IFeatureCreationAttributes>, IFeatureAttributes {}

const Feature = sequelize.define<IFeatureInstance, IFeatureCreationAttributes>('Feature', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  title: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  desc: {
    type: DataTypes.STRING(500),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 500]
    }
  },
  iconKey: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  },
  color: {
    type: DataTypes.STRING(7),
    defaultValue: '#3B82F6',
    validate: {
      is: /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/
    }
  }
}, {
  tableName: 'features',
  timestamps: true
});

export default Feature;