import { DataTypes, Model,type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface ICareerAttributes {
  id: number;
  title: string;
  location: string;
  type: 'Full-time' | 'Part-time' | 'Contract' | 'Internship';
  experience: string;
  description: string;
  requirements: string[];
  responsibilities: string[];
  benefits: string[];
  skills: string[];
  salaryRange?: string;
  department: string;
  isActive: boolean;
  applicationDeadline?: Date;
  createdAt: Date;
  updatedAt: Date;
}

export interface ICareerCreationAttributes extends Optional<ICareerAttributes, 'id' | 'salaryRange' | 'applicationDeadline' | 'isActive' | 'createdAt' | 'updatedAt'> {}

export interface ICareerInstance extends Model<ICareerAttributes, ICareerCreationAttributes>, ICareerAttributes {}

const Career = sequelize.define<ICareerInstance, ICareerCreationAttributes>('Career', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  title: {
    type: DataTypes.STRING(200),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 200]
    }
  },
  location: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  type: {
    type: DataTypes.ENUM('Full-time', 'Part-time', 'Contract', 'Internship'),
    allowNull: false,
    defaultValue: 'Full-time'
  },
  experience: {
    type: DataTypes.STRING(50),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 50]
    }
  },
  description: {
    type: DataTypes.TEXT,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  },
  requirements: {
    type: DataTypes.JSON,
    allowNull: false,
    defaultValue: []
  },
  responsibilities: {
    type: DataTypes.JSON,
    allowNull: false,
    defaultValue: []
  },
  benefits: {
    type: DataTypes.JSON,
    allowNull: false,
    defaultValue: []
  },
  skills: {
    type: DataTypes.JSON,
    allowNull: false,
    defaultValue: []
  },
  salaryRange: {
    type: DataTypes.STRING(100),
    allowNull: true
  },
  department: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  isActive: {
    type: DataTypes.BOOLEAN,
    allowNull: false,
    defaultValue: true
  },
  applicationDeadline: {
    type: DataTypes.DATE,
    allowNull: true
  }
}, {
  tableName: 'careers',
  timestamps: true
});

// Define associations
// Note: Associations will be defined after both models are loaded
// This will be handled in the main server file

export default Career;
