import { DataTypes, Model,type Optional } from 'sequelize';
import sequelize from '../config/database.js';

export interface IBlogAttributes {
  id: number;
  title: string;
  category: string;
  author: string;
  date: string;
  comments: number;
  rating: number;
  desc: string;
  href: string;
  image: string;
  content: string | null;
  createdAt: Date;
  updatedAt: Date;
}

export interface IBlogCreationAttributes extends Optional<IBlogAttributes, 'id' | 'comments' | 'content' | 'createdAt' | 'updatedAt'> {}

export interface IBlogInstance extends Model<IBlogAttributes, IBlogCreationAttributes>, IBlogAttributes {}

const Blog = sequelize.define<IBlogInstance, IBlogCreationAttributes>('Blog', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  title: {
    type: DataTypes.STRING(200),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 200]
    }
  },
  category: {
    type: DataTypes.STRING(50),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 50]
    }
  },
  author: {
    type: DataTypes.STRING(100),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 100]
    }
  },
  date: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  },
  comments: {
    type: DataTypes.INTEGER,
    defaultValue: 0,
    validate: {
      min: 0
    }
  },
  rating: {
    type: DataTypes.DECIMAL(2, 1),
    allowNull: false,
    validate: {
      min: 0,
      max: 5
    }
  },
  desc: {
    type: DataTypes.STRING(500),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 500]
    }
  },
  href: {
    type: DataTypes.STRING(200),
    allowNull: false,
    validate: {
      notEmpty: true,
      len: [1, 200]
    }
  },
  image: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      notEmpty: true
    }
  },
  content: {
    type: DataTypes.TEXT,
    allowNull: true
  }
}, {
  tableName: 'blogs',
  timestamps: true
});

export default Blog;